function getComponentsFromChannels(channels){
  var components=[];
  channels.forEach(function(channel){
    var channelComponents = channel.components;
    if(!channelComponents || channelComponents.length < 1){
      return alert('No components for channel '+channel.remoteId);
    }
    channelComponents.forEach(function(component){
      components.push({
        id: component.id,
        type: component.type,
        channel: channel.remoteId,
        profile: channel.profileId,
        label: component.label
      });
    });
    
  });

  return components;
}

function getComponentsByType(type, components){
  var _components=[];
  components.forEach(function(component){
    if(component.type === type){
      _components.push(component);
    }
  });
  return _components;
}


function getPropertiesFromChannels(channels, suportedClasses, supportedSchema){
  var properties=[];
  channels.forEach(function(channel){
    var channelProperties = channel.properties;
    if(!channelProperties || channelProperties.length < 1){
      return alert('No properties for channel'+ channel.remoteId);
    }
    channelProperties.forEach(function(property){
      var domain = (property.config) ? property.config : '';
      var propertyComponents = getComponentsIdByType(channel.components, property.components);
      propertyComponents.forEach(function(component){

        var classes = property.classes || property.class;
        if(!classes){
          return alert('No classes for '+property.id);
        }
        if(supportedSchema && supportedSchema.indexOf(property.schema) === -1){
          return alert('Schema not found');
        }
        classes.forEach(function(classs){
          if(suportedClasses.indexOf(classs) !== -1){
            properties.push({
              id: property.id,
              class: classs,
              config: (property.schemaExtension || ""),
              channel: channel.remoteId,
              profile: channel.profileId,
              schema: property.schema,
              component: component
            });
          }
        });
      });
    });
  });
  return properties;
}

function getSchemaByProperty(propertyy, component, channel, propertiesData){
  var schema = "";
  propertiesData.forEach(function(property){
    if(property.id === propertyy && property.component === component && property.channel === channel){
      schema =  property.schema;
      return schema;
    }
  });
  return schema;
}

function getLabelFromComponent(components, componentId){
  var label="";
  components.forEach(function(component){
    if(component.id === componentId){
      console.log(componentId+" - "+component.id+" - "+JSON.stringify(component));
      label = component.label;
      return label;
    }
  });
  return label;
}

function getComponentsIdByType(existingComponents, propertyComponent){
  var ids=[];
  existingComponents.forEach(function(eComponent){
    for(var i=0; i<propertyComponent.length; i++){
      if(eComponent.type === propertyComponent[i]){
        ids.push(eComponent.id);
      }
    }
  });
  return ids;
}

function setPropertyValueByClass(pClass, channelId, componentId, value, propertiesData){
  propertiesData.forEach(function(property){
    if(property.class == pClass && property.channel ==  channelId && property.component === componentId){
      property.value = value;
    }
  });
}

function getPropertyValueByClass(pClass, channelId, componentId, propertiesData){
  var value;
  propertiesData.forEach(function(property){
    if(property.class == pClass && property.channel ===  channelId && property.component === componentId){
      value = property.value;
      return value;
    }
  });
  return value;
}

function getClassById(id, channelId, componentId, propertiesData){
  var classs="";
  propertiesData.forEach(function(property){
    if(property.id == id && property.channel ==  channelId && property.component === componentId){
      classs = property.class;
      return classs;
    }
  });
  return classs;
}

function getComponent(componentId, componentsData){
  var exists = false;
  componentsData.forEach(function(component){
    if(component.id === componentId){
      exists = true;
      return exists;
    }
  });
  return exists;
}

function getComponentFromId(componentId, componentsData){
  var _component=null;
  componentsData.forEach(function(component){
    if(component.id === componentId){
      _component = component;
      return _component;
    }
  });
  return _component;
}

function getClassIdByComponent(componentId, channelId, propertyClass, propertiesData){
  var _property="";
  propertiesData.forEach(function(property){
    if(property.class == propertyClass && property.channel ==  channelId && property.component === componentId){
      _property = property.id;
      return _property;
    }
  });
  return _property;
}

function getPropertyByComponent(componentId, propertyClass, propertiesData){
  var _property=null;
  propertiesData.forEach(function(property){
    if(property.class == propertyClass && property.component === componentId){
      _property = property;
      return _property;
    }
  });
  return _property;
}